$(document).ready(function(){
	$('.nav a').on('click', function(e){
		e.preventDefault();
		var new_target = $(this);
		new_page(new_target.attr('title'), new_target.attr('href'), new_target.data('image'), new_target.data('link'));
	});
	
	var new_page = function(title, url, banner, link, skip_history) {

		// Update all of the content
		$('.banner').attr('src', banner);
		document.title = title;
		
		$('h1').html(title);
		$('.banner').parent().attr('href', link);
		var stateObj = {
			title: title,
			url: url,
			banner: banner,
			link: link
		}
		
		// check to see if added to history or skipped
		if (!skip_history) {
			// check if can handle pushState
			if (typeof window.history.pushState == 'function') {
				// push on to history
				window.history.pushState(stateObj,title,url);
			}
		}
		
		update_social(title, url);
		
	}
	
	var update_social = function(title, url) {
		
		// Add a new pageview to Analytics
		if (typeof _gaq !== 'undefined')
		{
			window._gaq.push(['_trackPageview', url]);
		}
		
		//Need the full URL for outside sites
		var full_url = window.location.href;
		
		//Populate new Facebook widget
		$('#fb-like').html('<fb:like href="' + full_url + '" show_faces="false" width="350" action="like" send="true" font="segoe ui" colorscheme="light" />');
		
		//Reload Facebook
		if (typeof FB !== 'undefined') {
			FB.XFBML.parse(document.getElementById('fb-like'));
		}
		
		//Populate new Twitter widget
		var twitter_text = title + " via " + "@buildinternet";
		$('#twitter-share').html('<a href="https://twitter.com/share" vclass="twitter-share-button" data-url="' + full_url + '" data-text="'+ twitter_text +'" data-related="buildinternet">Tweet</a>');
		
		//Reload Twitter
		if (typeof twttr !== 'undefined') {
			twttr.widgets.load();
		}
	}
	
	// add opstate listener
	window.onpopstate = function(event) {

		// if is one of ours
		if (event.state) {
			console.log(event.state);
			// load the content
			new_page(event.state.title, window.location.pathname, event.state.banner, event.state.link, true);
		}
		else { // we need to make it one of ours
			// generate stateObj, this is used on the pop event
			var stateObj = {
				title: document.title,
				url: window.location.pathname,
				banner: $('.banner').attr('src'),
				link: $('.banner').parent().attr('href')
			};

			window.history.replaceState(stateObj,document.title,window.location.pathname);
		}
	}
	
});